[![](../.github/assets/smt_logo.png)](https://github.com/social-manager-tools/social-manager-tools)
[![](../.github/assets/smt_igbot_logo.png)](https://github.com/social-manager-tools/socialmanagertools-igbot)
[![](../.github/assets/smt_twbot_logo.png)](https://github.com/social-manager-tools/socialmanagertools-twbot)
[![](../.github/assets/smt_fbbot_logo.png)](https://github.com/social-manager-tools/socialmanagertools-fbbot)
[![](../.github/assets/smt_wpbot_logo.png)](https://github.com/social-manager-tools/social-manager-tools-tgbot-api)
[![](../.github/assets/smt_mebot_logo.png)](https://github.com/social-manager-tools/social-manager-tools-tgbot-api)

# 🤖 Social Manager Tools: Documentation
> This is official English documentation. Available languages: [🇬🇧](../en/README.md)

## 🦄 How can I help?
- 🌎 See [Translators Guidelines](./docs/translation/guidesline/README.md).
- 💻 See [Developers Guidelines](./developers/guidesline/README.md)

## 📎 Documentation Index
- 💾 Installation:
  - 🛠 [GUI: Social Manager Tools](./gui/installation/README.md) (Windows, Mac, Linux)
  - 🔧 [CLI: Instagram Bot](./igbot/installation/README.md)
  - 🔧 [CLI: Twitter Bot](./twbot/installation/README.md)
  - 🔧 [CLI: Facebook Bot](./fbbot/installation/README.md)
  - 🔧 [CLI: Telegram Wordpress &amp; Medium Bot](./tgbot/installation/README.md)
- 📐 Configs:
  - 🔌 [VPN/Proxy](./igbot/configs/vpn-proxy/README.md)
  - 💿 [Modes: Instagram Bot](./igbot/configs/modes/README.md) (Social Algorithms)
  - 💿 [Modes: Twitter Bot](./twbot/configs/modes/README.md) (Social Algorithms)
  - 💿 [Modes: Facebook Bot](./fbbot/configs/modes/README.md) (Social Algorithms)
  - 📀 [Multi-account: Instagram Bot](./igbot/configs/multiaccount/README.md)
  - 📀 [Multi-account: Twitter Bot](./twbot/configs/multiaccount/README.md)
  - 📀 [Multi-account: Facebook Bot](./fbbot/configs/multiaccount/README.md)
- 📚 API Documentation (only for Developers):
  - 📗 [API: Instagram Bot](./igbot/api/README.md)
  - 📕 [API: Twitter Bot](./twbot/api/README.md)
  - 📘 [API: Facebook Bot](./fbbot/api/README.md)
  - 📙 [API: Telegram Wordpress &amp; Medium Bot](./tgbot/api/README.md)
- 🍻 Community:
  - 🐦 [Telegram group](http://telegram.ptkdev.io)
  - 🐔 [Discord](http://discord.ptkdev.io)
  - 🐓 [Slack](http://slack.ptkdev.io)
  - 🕊 [Medium](http://blog.ptkdev.io)
  - 🐤 [Twitter](https://twitter.com/ptkdevio)

### 🎁 Support: Donate
[![](https://img.shields.io/badge/donate-paypal-005EA6.svg)](http://paypal.ptkdev.io) [![](https://img.shields.io/badge/donate-patreon-F87668.svg)](http://patreon.ptkdev.io) [![](https://img.shields.io/badge/donate-opencollective-5DA4F9.svg)](http://opencollective.ptkdev.io) [![](https://img.shields.io/badge/buy%20me-coffee-4B788C.svg)](http://coffee.ptkdev.io)

## 👑 Sponsors
Support this project by becoming a sponsor. 🙏 Become a sponsor on [patreon](https://www.patreon.com/join/ptkdev) or become top3 sponsor on [ko-fi](https://ko-fi.com/ptkdev). Your logo will show up here with a link to your website.

[![](https://api.ptkdev.io/backers/sponsor1.png)](https://api.ptkdev.io/backers/sponsor1.html) [![](https://api.ptkdev.io/backers/sponsor2.png)](https://api.ptkdev.io/backers/sponsor2.html) [![](https://api.ptkdev.io/backers/sponsor-kofi1.png)](https://api.ptkdev.io/backers/sponsor-kofi1.html) [![](https://api.ptkdev.io/backers/sponsor-kofi2.png)](https://api.ptkdev.io/backers/sponsor-kofi2.html) [![](https://api.ptkdev.io/backers/sponsor-kofi3.png)](https://api.ptkdev.io/backers/sponsor-kofi3.html) [![](https://api.ptkdev.io/backers/sponsor3.png)](https://api.ptkdev.io/backers/sponsor3.html) [![](https://api.ptkdev.io/backers/sponsor4.png)](https://api.ptkdev.io/backers/sponsor4.html) [![](https://api.ptkdev.io/backers/sponsor5.png)](https://api.ptkdev.io/backers/sponsor5.html) [![](https://api.ptkdev.io/backers/sponsor6.png)](https://api.ptkdev.io/backers/sponsor6.html) [![](https://api.ptkdev.io/backers/sponsor7.png)](https://api.ptkdev.io/backers/sponsor7.html) [![](https://api.ptkdev.io/backers/sponsor8.png)](https://api.ptkdev.io/backers/sponsor8.html) [![](https://api.ptkdev.io/backers/sponsor9.png)](https://api.ptkdev.io/backers/sponsor9.html) [![](https://api.ptkdev.io/backers/sponsor10.png)](https://api.ptkdev.io/backers/sponsor10.html) [![](https://api.ptkdev.io/backers/sponsor11.png)](https://api.ptkdev.io/backers/sponsor11.html) [![](https://api.ptkdev.io/backers/sponsor12.png)](https://api.ptkdev.io/backers/sponsor12.html) [![](https://api.ptkdev.io/backers/sponsor13.png)](https://api.ptkdev.io/backers/sponsor13.html) [![](https://api.ptkdev.io/backers/sponsor14.png)](https://api.ptkdev.io/backers/sponsor14.html) [![](https://api.ptkdev.io/backers/sponsor15.png)](https://api.ptkdev.io/backers/sponsor15.html)

## 🦄 Backers
Thank you to all our backers! 🙏 Become a backer on [patreon](https://www.patreon.com/join/ptkdev).

[![](https://api.ptkdev.io/backers/backer1.png)](https://api.ptkdev.io/backers/backer1.html) [![](https://api.ptkdev.io/backers/backer2.png)](https://api.ptkdev.io/backers/backer2.html) [![](https://api.ptkdev.io/backers/backer3.png)](https://api.ptkdev.io/backers/backer3.html) [![](https://api.ptkdev.io/backers/backer4.png)](https://api.ptkdev.io/backers/backer4.html) [![](https://api.ptkdev.io/backers/backer5.png)](https://api.ptkdev.io/backers/backer5.html) [![](https://api.ptkdev.io/backers/backer6.png)](https://api.ptkdev.io/backers/backer6.html) [![](https://api.ptkdev.io/backers/backer7.png)](https://api.ptkdev.io/backers/backer7.html) [![](https://api.ptkdev.io/backers/backer8.png)](https://api.ptkdev.io/backers/backer8.html) [![](https://api.ptkdev.io/backers/backer9.png)](https://api.ptkdev.io/backers/backer9.html) [![](https://api.ptkdev.io/backers/backer10.png)](https://api.ptkdev.io/backers/backer10.html) [![](https://api.ptkdev.io/backers/backer11.png)](https://api.ptkdev.io/backers/backer11.html) [![](https://api.ptkdev.io/backers/backer12.png)](https://api.ptkdev.io/backers/backer12.html) [![](https://api.ptkdev.io/backers/backer13.png)](https://api.ptkdev.io/backers/backer13.html) [![](https://api.ptkdev.io/backers/backer14.png)](https://api.ptkdev.io/backers/backer14.html) [![](https://api.ptkdev.io/backers/backer15.png)](https://api.ptkdev.io/backers/backer15.html)


## ❤️ Contributing
I 💟 contributions! I will happily accept your pull request! Examples, Documentation, Translations and grammatical corrections (GrammarNazi you are welcome! Yes my English is bad, sorry). Remember to insert your name in `.all-contributorsrc` and `package.json` file.

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START -->
<!-- prettier-ignore -->
<table><tr><td align="center"><a href="https://ptk.dev"><img src="https://avatars1.githubusercontent.com/u/442844?v=4" width="100px;" alt="Patryk Rzucidło"/><br /><sub><b>Patryk Rzucidło</b></sub></a><br /><a href="https://github.com/ptkdev/socialmanagertools-docs/commits?author=ptkdev" title="Documentation">📖</a> <a href="#translation-ptkdev" title="Translation">🌍</a></td><td align="center"><a href="https://github.com/MoltenKH0R"><img src="https://avatars1.githubusercontent.com/u/6023575?v=4" width="100px;" alt="MoltenKH0R"/><br /><sub><b>MoltenKH0R</b></sub></a><br /><a href="#translation-MoltenKH0R" title="Translation">🌍</a></td></tr></table>

<!-- ALL-CONTRIBUTORS-LIST:END -->

> 💰 In the future, if the donations allow it, I would like to share some of the success with those who helped me the most. For me open source is share of code, share development knowledges and share donations!

## 💫 License
* Documentation and Contributions have **CC BY 4.0 License**
* Images and Logos have **CC BY-NC 4.0 License**
* Code Snippets/Examples have **MIT License**

###### Copyleft (c) 2018-2019 [Patryk Rzucidło](https://ptk.dev) ([@PTKDev](https://twitter.com/ptkdev)) <[support@ptkdev.io](mailto:support@ptkdev.io)>