> 📌 [index](../../../README.md) / 🐣 twbot / 💾 [installation](../README.md) / 🦀 [raspberry pi](README.md)

# 🦀 Setup - Raspbian 9
## 1. Install chromium v69 or never
Run `sudo apt-get install chromium-browser`

## 2. Install Node v10
1. `curl -sL https://deb.nodesource.com/setup_10.x -o nodesource_setup.sh `
2. `sudo bash nodesource_setup.sh`
3. `rm nodesource_setup.sh`
4. `sudo apt-get install nodejs npm`

**INFO**: some people have encountered problems with node `10.x`, try downgrade to `8.x` if not work.

## 4. Run
1. Download [latest bot version](https://github.com/social-manager-tools/socialmanagertools-twbot/archive/master.zip) and extract it.
2. Run `export PUPPETEER_SKIP_CHROMIUM_DOWNLOAD=1` or `env PUPPETEER_SKIP_CHROMIUM_DOWNLOAD=1`
3. Run `npm install` in `socialmanagertools-twbot-master` folder.
4. Get [config.js](https://raw.githubusercontent.com/social-manager-tools/socialmanagertools-twbot/master/configs/config.js.tpl) remove  `.tpl ` suffix and insert file into `configs` folder, fill it properly.
5. Edit `configs/config.js` and set `chrome_executable_path` to `/usr/bin/chromium-browser` in puppeteer section.
6. Start the bot via `npm run start`
7. If it works add a star 🌟 at this project.
8. If you want to help me: **donate on [paypal](http://paypal.ptkdev.io)/[ko-fi](http://coffee.ptkdev.io)** or become a **[backer on patreon](http://patreon.ptkdev.io)**.

## 5. You don't have monitor?
- Edit `configs/config.js` and set `chrome_headless` to `enabled` (or to `true` in `v0.9.X` version), is mandatory.

## 6. Install correct puppeteer module
If bot not work or chrome/chromium crash try install correct version of puppeteer library.
- If you use `chrome/chromium v68` run `npm install puppeteer@1.4.0`
- If you use `chrome/chromium v69` run `npm install puppeteer@1.6.2`
- If you use `chrome/chromium v70` run `npm install puppeteer@1.7.0`
- If you use `chrome/chromium v71` run `npm install puppeteer@1.9.0`
- If you use `chrome/chromium v72` run `npm install puppeteer@1.11.0`
- If you use `chrome/chromium v73` run `npm install puppeteer@1.12.2`
- If you use `chrome/chromium v74` run `npm install puppeteer@1.13.0`

See other version [here](https://github.com/GoogleChrome/puppeteer/releases).

# 🦞 Setup - Raspbian 8
## 1. Install chromium v60
Run `sudo apt-get install chromium-browser`

## 2. Install Node v10
1. `curl -sL https://deb.nodesource.com/setup_10.x -o nodesource_setup.sh `
2. `sudo bash nodesource_setup.sh`
3. `rm nodesource_setup.sh`
4. `sudo apt-get install nodejs npm`

## 3. Update chromium v60 to v69
```sh
wget https://launchpad.net/~chromium-team/+archive/ubuntu/stable/+build/15466406/+files/chromium-codecs-ffmpeg-extra_69.0.3497.100-0ubuntu0.16.04.1_armhf.deb
wget https://launchpad.net/~chromium-team/+archive/ubuntu/stable/+build/15466406/+files/chromium-codecs-ffmpeg_69.0.3497.100-0ubuntu0.16.04.1_armhf.deb
wget https://launchpad.net/~chromium-team/+archive/ubuntu/stable/+build/15466406/+files/chromium-browser_69.0.3497.100-0ubuntu0.16.04.1_armhf.deb

sudo dpkg -i chromium-codecs-ffmpeg-extra_69.0.3497.100-0ubuntu0.16.04.1_armhf.deb
sudo dpkg -i chromium-codecs-ffmpeg_69.0.3497.100-0ubuntu0.16.04.1_armhf.deb
sudo dpkg -i chromium-browser_69.0.3497.100-0ubuntu0.16.04.1_armhf.deb
sudo apt-get install -f
```

## 4. If you have problem with libc dependieces you need update raspbian to testing:
- Edit `sudo vi /etc/apt/source.list` and switch `stretch` to `testing`
- Run `sudo apt-get update && sudo apt-get dist-upgrade`

## 5. Run
1. Download [latest bot version](https://github.com/social-manager-tools/socialmanagertools-twbot/archive/master.zip) and extract it.
2. Run `export PUPPETEER_SKIP_CHROMIUM_DOWNLOAD=1` or `env PUPPETEER_SKIP_CHROMIUM_DOWNLOAD=1`
3. Run `npm install` in `socialmanagertools-twbot-master` folder.
4. Get [config.js](https://raw.githubusercontent.com/social-manager-tools/socialmanagertools-twbot/master/configs/config.js.tpl) remove  `.tpl ` suffix and insert file into `configs` folder, fill it properly.
5. Edit `configs/config.js` and set `chrome_executable_path` to `/usr/bin/chromium-browser` in puppeteer section.
6. Start the bot via `npm run start`
7. If it works add a star 🌟 at this project.
8. If you want to help me: **donate on [paypal](http://paypal.ptkdev.io)/[ko-fi](http://coffee.ptkdev.io)** or become a **[backer on patreon](http://patreon.ptkdev.io)**.

## 6. You don't have monitor?
- Edit `config.js` and set `chrome_headless` to `enabled` (or to `true` in `v0.9.X` version), is mandatory.

## 7. Install correct puppeteer module
If bot not work or chrome/chromium crash try install correct version of puppeteer library.
- If you use `chrome/chromium v68` run `npm install puppeteer@1.4.0`
- If you use `chrome/chromium v69` run `npm install puppeteer@1.6.2`
- If you use `chrome/chromium v70` run `npm install puppeteer@1.7.0`
- If you use `chrome/chromium v71` run `npm install puppeteer@1.9.0`
- If you use `chrome/chromium v72` run `npm install puppeteer@1.11.0`
- If you use `chrome/chromium v73` run `npm install puppeteer@1.12.2`
- If you use `chrome/chromium v74` run `npm install puppeteer@1.13.0`

See other version [here](https://github.com/GoogleChrome/puppeteer/releases).

## 🎁 Support: Donate
[![](https://img.shields.io/badge/donate-paypal-005EA6.svg)](http://paypal.ptkdev.io) [![](https://img.shields.io/badge/donate-patreon-F87668.svg)](http://patreon.ptkdev.io) [![](https://img.shields.io/badge/donate-opencollective-5DA4F9.svg)](http://opencollective.ptkdev.io) [![](https://img.shields.io/badge/buy%20me-coffee-4B788C.svg)](http://coffee.ptkdev.io)

## 💫 License
* Documentation and Contributions have **CC BY 4.0 License**
* Images and Logos have **CC BY-NC 4.0 License**
* Code Snippets/Examples have **MIT License**

###### Copyleft (c) 2018-2019 [Patryk Rzucidło](https://ptk.dev) ([@PTKDev](https://twitter.com/ptkdev)) <[support@ptkdev.io](mailto:support@ptkdev.io)>