import Utils from "../../../utils/utils";

export default function () {
    const swiper = this;
    const { activeIndex, loopedSlides = 0, params } = swiper;
    const breakpoints = params.breakpoints;
    if (!breakpoints || (breakpoints && Object.keys(breakpoints).length === 0)) return;
    // Set breakpoint for window width and update parameters
    const breakpoint = swiper.getBreakpoint(breakpoints);
    if (breakpoint && swiper.currentBreakpoint !== breakpoint) {
        const breakPointsParams = breakpoint in breakpoints ? breakpoints[breakpoint] : swiper.originalParams;
        const needsReLoop = params.loop && (breakPointsParams.slidesPerView !== params.slidesPerView);

        Utils.extend(swiper.params, breakPointsParams);

        Utils.extend(swiper, {
            allowTouchMove: swiper.params.allowTouchMove,
            allowSlideNext: swiper.params.allowSlideNext,
            allowSlidePrev: swiper.params.allowSlidePrev,
        });

        swiper.currentBreakpoint = breakpoint;

        if (needsReLoop) {
            swiper.loopDestroy();
            swiper.loopCreate();
            swiper.updateSlides();
            swiper.slideTo((activeIndex - loopedSlides) + swiper.loopedSlides, 0, false);
        }
        swiper.emit("breakpoint", breakPointsParams);
    }
}
