import { document } from "ssr-window";
import Device from "../../../utils/device";
import Support from "../../../utils/support";

import onTouchStart from "./onTouchStart";
import onTouchMove from "./onTouchMove";
import onTouchEnd from "./onTouchEnd";
import onResize from "./onResize";
import onClick from "./onClick";

function attachEvents() {
    const swiper = this;
    const {
        params, touchEvents, el, wrapperEl,
    } = swiper;

    if ("universal" !== "desktop") {
        swiper.onTouchStart = onTouchStart.bind(swiper);
        swiper.onTouchMove = onTouchMove.bind(swiper);
        swiper.onTouchEnd = onTouchEnd.bind(swiper);
    }

    swiper.onClick = onClick.bind(swiper);

    const target = params.touchEventsTarget === "container" ? el : wrapperEl;
    const capture = !!params.nested;

    // Touch Events
    if (process.env.TARGET !== "desktop") {
        if (!Support.touch && (Support.pointerEvents || Support.prefixedPointerEvents)) {
            target.addEventListener(touchEvents.start, swiper.onTouchStart, false);
            document.addEventListener(touchEvents.move, swiper.onTouchMove, capture);
            document.addEventListener(touchEvents.end, swiper.onTouchEnd, false);
        } else {
            if (Support.touch) {
                const passiveListener = touchEvents.start === "touchstart" && Support.passiveListener && params.passiveListeners ? { passive: true, capture: false } : false;
                target.addEventListener(touchEvents.start, swiper.onTouchStart, passiveListener);
                target.addEventListener(touchEvents.move, swiper.onTouchMove, Support.passiveListener ? { passive: false, capture } : capture);
                target.addEventListener(touchEvents.end, swiper.onTouchEnd, passiveListener);
            }
            if ((params.simulateTouch && !Device.ios && !Device.android) || (params.simulateTouch && !Support.touch && Device.ios)) {
                target.addEventListener("mousedown", swiper.onTouchStart, false);
                document.addEventListener("mousemove", swiper.onTouchMove, capture);
                document.addEventListener("mouseup", swiper.onTouchEnd, false);
            }
        }
        // Prevent Links Clicks
        if (params.preventClicks || params.preventClicksPropagation) {
            target.addEventListener("click", swiper.onClick, true);
        }
    } else {
        target.addEventListener("click", swiper.onClick, false);
    }

    // Resize handler
    swiper.on("resize observerUpdate", onResize, true);
}

function detachEvents() {
    const swiper = this;

    const {
        params, touchEvents, el, wrapperEl,
    } = swiper;

    const target = params.touchEventsTarget === "container" ? el : wrapperEl;
    const capture = !!params.nested;

    // Touch Events
    if (process.env.TARGET !== "desktop") {
        if (!Support.touch && (Support.pointerEvents || Support.prefixedPointerEvents)) {
            target.removeEventListener(touchEvents.start, swiper.onTouchStart, false);
            document.removeEventListener(touchEvents.move, swiper.onTouchMove, capture);
            document.removeEventListener(touchEvents.end, swiper.onTouchEnd, false);
        } else {
            if (Support.touch) {
                const passiveListener = touchEvents.start === "onTouchStart" && Support.passiveListener && params.passiveListeners ? { passive: true, capture: false } : false;
                target.removeEventListener(touchEvents.start, swiper.onTouchStart, passiveListener);
                target.removeEventListener(touchEvents.move, swiper.onTouchMove, capture);
                target.removeEventListener(touchEvents.end, swiper.onTouchEnd, passiveListener);
            }
            if ((params.simulateTouch && !Device.ios && !Device.android) || (params.simulateTouch && !Support.touch && Device.ios)) {
                target.removeEventListener("mousedown", swiper.onTouchStart, false);
                document.removeEventListener("mousemove", swiper.onTouchMove, capture);
                document.removeEventListener("mouseup", swiper.onTouchEnd, false);
            }
        }
        // Prevent Links Clicks
        if (params.preventClicks || params.preventClicksPropagation) {
            target.removeEventListener("click", swiper.onClick, true);
        }
    } else {
        target.removeEventListener("click", swiper.onClick, true);
    }

    // Resize handler
    swiper.off("resize observerUpdate", onResize);
}

export default {
    attachEvents,
    detachEvents,
};
