import { document } from "ssr-window";
import $ from "../../../utils/dom";

export default function () {
    const swiper = this;
    const { params, $wrapperEl } = swiper;
    // Remove duplicated slides
    $wrapperEl.children(`.${params.slideClass}.${params.slideDuplicateClass}`).remove();

    let slides = $wrapperEl.children(`.${params.slideClass}`);

    if (params.loopFillGroupWithBlank) {
        const blankSlidesNum = params.slidesPerGroup - (slides.length % params.slidesPerGroup);
        if (blankSlidesNum !== params.slidesPerGroup) {
            for (let i = 0; i < blankSlidesNum; i += 1) {
                const blankNode = $(document.createElement("div")).addClass(`${params.slideClass} ${params.slideBlankClass}`);
                $wrapperEl.append(blankNode);
            }
            slides = $wrapperEl.children(`.${params.slideClass}`);
        }
    }

    if (params.slidesPerView === "auto" && !params.loopedSlides) params.loopedSlides = slides.length;

    swiper.loopedSlides = parseInt(params.loopedSlides || params.slidesPerView, 10);
    swiper.loopedSlides += params.loopAdditionalSlides;
    if (swiper.loopedSlides > slides.length) {
        swiper.loopedSlides = slides.length;
    }

    const prependSlides = [];
    const appendSlides = [];
    slides.each((index, el) => {
        const slide = $(el);
        if (index < swiper.loopedSlides) appendSlides.push(el);
        if (index < slides.length && index >= slides.length - swiper.loopedSlides) prependSlides.push(el);
        slide.attr("data-swiper-slide-index", index);
    });
    for (let i = 0; i < appendSlides.length; i += 1) {
        $wrapperEl.append($(appendSlides[i].cloneNode(true)).addClass(params.slideDuplicateClass));
    }
    for (let i = prependSlides.length - 1; i >= 0; i -= 1) {
        $wrapperEl.prepend($(prependSlides[i].cloneNode(true)).addClass(params.slideDuplicateClass));
    }
}
