export default function (runCallbacks = true, direction) {
    const swiper = this;
    const { activeIndex, params, previousIndex } = swiper;
    if (params.autoHeight) {
        swiper.updateAutoHeight();
    }

    let dir = direction;
    if (!dir) {
        if (activeIndex > previousIndex) dir = "next";
        else if (activeIndex < previousIndex) dir = "prev";
        else dir = "reset";
    }

    swiper.emit("transitionStart");

    if (runCallbacks && activeIndex !== previousIndex) {
        if (dir === "reset") {
            swiper.emit("slideResetTransitionStart");
            return;
        }
        swiper.emit("slideChangeTransitionStart");
        if (dir === "next") {
            swiper.emit("slideNextTransitionStart");
        } else {
            swiper.emit("slidePrevTransitionStart");
        }
    }
}
