import $ from "../../../utils/dom";

export default function (e) {
    const swiper = this;
    const params = swiper.params;
    const slide = $(e.target).closest(`.${params.slideClass}`)[0];
    let slideFound = false;
    if (slide) {
        for (let i = 0; i < swiper.slides.length; i += 1) {
            if (swiper.slides[i] === slide) slideFound = true;
        }
    }

    if (slide && slideFound) {
        swiper.clickedSlide = slide;
        if (swiper.virtual && swiper.params.virtual.enabled) {
            swiper.clickedIndex = parseInt($(slide).attr("data-swiper-slide-index"), 10);
        } else {
            swiper.clickedIndex = $(slide).index();
        }
    } else {
        swiper.clickedSlide = undefined;
        swiper.clickedIndex = undefined;
        return;
    }
    if (params.slideToClickedSlide && swiper.clickedIndex !== undefined && swiper.clickedIndex !== swiper.activeIndex) {
        swiper.slideToClickedSlide();
    }
}
