import $ from "../../utils/dom";
import Utils from "../../utils/utils";

const Parallax = {
    setTransform(el, progress) {
        const swiper = this;
        const { rtl } = swiper;

        const $el = $(el);
        const rtlFactor = rtl ? -1 : 1;

        const p = $el.attr("data-swiper-parallax") || "0";
        let x = $el.attr("data-swiper-parallax-x");
        let y = $el.attr("data-swiper-parallax-y");
        const scale = $el.attr("data-swiper-parallax-scale");
        const opacity = $el.attr("data-swiper-parallax-opacity");

        if (x || y) {
            x = x || "0";
            y = y || "0";
        } else if (swiper.isHorizontal()) {
            x = p;
            y = "0";
        } else {
            y = p;
            x = "0";
        }

        if ((x).indexOf("%") >= 0) {
            x = `${parseInt(x, 10) * progress * rtlFactor}%`;
        } else {
            x = `${x * progress * rtlFactor}px`;
        }
        if ((y).indexOf("%") >= 0) {
            y = `${parseInt(y, 10) * progress}%`;
        } else {
            y = `${y * progress}px`;
        }

        if (typeof opacity !== "undefined" && opacity !== null) {
            const currentOpacity = opacity - ((opacity - 1) * (1 - Math.abs(progress)));
            $el[0].style.opacity = currentOpacity;
        }
        if (typeof scale === "undefined" || scale === null) {
            $el.transform(`translate3d(${x}, ${y}, 0px)`);
        } else {
            const currentScale = scale - ((scale - 1) * (1 - Math.abs(progress)));
            $el.transform(`translate3d(${x}, ${y}, 0px) scale(${currentScale})`);
        }
    },
    setTranslate() {
        const swiper = this;
        const {
            $el, slides, progress, snapGrid,
        } = swiper;
        $el.children("[data-swiper-parallax], [data-swiper-parallax-x], [data-swiper-parallax-y]")
            .each((index, el) => {
                swiper.parallax.setTransform(el, progress);
            });
        slides.each((slideIndex, slideEl) => {
            let slideProgress = slideEl.progress;
            if (swiper.params.slidesPerGroup > 1 && swiper.params.slidesPerView !== "auto") {
                slideProgress += Math.ceil(slideIndex / 2) - (progress * (snapGrid.length - 1));
            }
            slideProgress = Math.min(Math.max(slideProgress, -1), 1);
            $(slideEl).find("[data-swiper-parallax], [data-swiper-parallax-x], [data-swiper-parallax-y]")
                .each((index, el) => {
                    swiper.parallax.setTransform(el, slideProgress);
                });
        });
    },
    setTransition(duration = this.params.speed) {
        const swiper = this;
        const { $el } = swiper;
        $el.find("[data-swiper-parallax], [data-swiper-parallax-x], [data-swiper-parallax-y]")
            .each((index, parallaxEl) => {
                const $parallaxEl = $(parallaxEl);
                let parallaxDuration = parseInt($parallaxEl.attr("data-swiper-parallax-duration"), 10) || duration;
                if (duration === 0) parallaxDuration = 0;
                $parallaxEl.transition(parallaxDuration);
            });
    },
};

export default {
    name: "parallax",
    params: {
        parallax: {
            enabled: false,
        },
    },
    create() {
        const swiper = this;
        Utils.extend(swiper, {
            parallax: {
                setTransform: Parallax.setTransform.bind(swiper),
                setTranslate: Parallax.setTranslate.bind(swiper),
                setTransition: Parallax.setTransition.bind(swiper),
            },
        });
    },
    on: {
        beforeInit() {
            const swiper = this;
            if (!swiper.params.parallax.enabled) return;
            swiper.params.watchSlidesProgress = true;
        },
        init() {
            const swiper = this;
            if (!swiper.params.parallax) return;
            swiper.parallax.setTranslate();
        },
        setTranslate() {
            const swiper = this;
            if (!swiper.params.parallax) return;
            swiper.parallax.setTranslate();
        },
        setTransition(duration) {
            const swiper = this;
            if (!swiper.params.parallax) return;
            swiper.parallax.setTransition(duration);
        },
    },
};
